program Numeri
use input_vars 
use model_vars
implicit none
character (len=255):: outfil 
character (len=14):: folder='results\'
character (len=18):: profil='list_z_p_fs_numerical'
integer:: nra,nrb,nrc,m
integer:: i,j,jf,k,ulog,u1,imx1
double precision:: lt,lb,rkst,rksb
double precision:: finf,fmn,ts

!constant parameter
pi=3.141592653587973d0
eps=1.0d-18

nmax=10
nzst=26
nzsb=26

allocate (pt(nzst+1),pb(nzsb+1),pt0(nzst+1),pb0(nzsb+1),pt1(nzst+1),pb1(nzsb+1),pt2(nzst+1),pb2(nzsb+1))
allocate (fc(nzst+nzsb+1),fw(nzst+nzsb+1),inithzt(nzst+1),inithzb(nzsb+1),inidesatt(nzst+1),inidesatb(nzsb+1),desatt(nzst+1),desatb(nzsb+1),thzt(nzst+1),thzb(nzsb+1))
allocate (uwspt(nzst+1),uwspb(nzsb+1))
pt=0.; pb=0.; pt0=0.; pb0=0.; pt1=0.; pb1=0.; pt2=0.; pb2=0.;
fc=0.; fw=0.
inithzt=0.; inithzb=0.
inidesatt=0.; inidesatb=0.
desatt=0.; desatb=0.
thzb=0.; thzt=0.
uwspt=0.; uwspb=0.

nout=4
allocate (tsav(nout))
tsav=(/5,10,15,20/) ! profile at t=0 is saved as initial condition

dg2rad=pi/180.D0

ltstar=400.0
lbstar=100.0
alphat=0.01
alphab=0.01
thsatt=0.42
thsatb=0.3
thresit=0.18
thresib=0.1
kst=3.6
ksb=0.036
qa=0.
qb=3.6
slo=40.*dg2rad

uwst=2.1e4
uwsb=2.1e4

! loop over all grid cells
finf=10.

write (*,*) 'start computing' 

! initialize time parameters
! t0 is the starting time of simulation
! dt is the time step of simulation, which is set to be dtmin at the beginning
! tout is the output interval, ttout is the output time
! tminimum is used to record the minimum time step
! tmaximum is used to record the maximum time step
! tnow is the present time
! ntsdeb is used to record the number of time step of debris flow simulation
t0=0.
dt=0.0005
tnow=t0
ntsdeb=0
simul=24.
! compute the maximum possbile steps to finish the simulation
maxnts=2*simul/dt


outfil=trim(folder)//trim(profil)//'.txt'
open (u1,file=outfil,err=10)

call doublelayer(u1,tsav,finf,fmn)


close(u1)
pause 'The program Numeri runs successfully!'
stop '0'

10  continue
  	write (*,*) 'Error opening output file'
	write (*,*) '--> ',trim(outfil)
	write (*,*) 'Check file path and status'
	pause 'Press RETURN to exit'
    close(u1)
	stop
	
end